<?php
/* --------------------------------------------------------------
 SaveConfigurations.php 2019-12-16
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2019 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Core\Configuration\Action;

use Gambio\Admin\Application\Http\AbstractAction;
use Gambio\Core\Configuration\ConfigurationService;
use Gambio\Core\Configuration\Models\Write\Configuration;
use Slim\Http\Response;

/**
 * Class SaveConfigurations
 * @package Gambio\Core\Configuration\Action
 *
 * @codeCoverageIgnore
 */
class SaveConfigurations extends AbstractAction
{
    /**
     * @var ConfigurationService
     */
    private $service;
    
    
    /**
     * SaveConfigurations constructor.
     *
     * @param ConfigurationService $service
     */
    public function __construct(ConfigurationService $service)
    {
        $this->service = $service;
    }
    
    
    /**
     * @inheritDoc
     */
    protected function process(): Response
    {
        $groupId = $this->request->getParsedBodyParam('redirect-to', '1');
        
        $requestBody = $this->processRequestBody($this->request->getParsedBody());
        $this->service->save(...Configuration::bulkCreate($requestBody));
        
        $redirectUri = "{$this->url->admin()}/configuration.php?gID={$groupId}";
        
        return $this->response->withRedirect($redirectUri);
    }
    
    
    /**
     * Processes the request body.
     *
     * This function checks the request data for array values containing the key "glue" and processes them.
     * It is needed to support multi switcher configuration values and left everything
     * else untouched.
     *
     * @param array $requestBody
     *
     * @return array
     */
    private function processRequestBody(array $requestBody): array
    {
        $filterCallback = function (string $element) {
            return $element === 'true';
        };
        
        foreach ($requestBody as $key => &$value) {
            if (is_array($value) && array_key_exists('glue', $value)) {
                $glue = $value['glue'];
                unset($value['glue']);
                
                $value = array_filter($value, $filterCallback);
                $value = implode($glue, array_keys($value));
            }
        }
        
        return $requestBody;
    }
}